class MotorsInventorySearchResults extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				search_results: '.motors-elementor-inventory-search-results .stm-isotope-sorting',
				listing_thumb: '.stm-isotope-listing-item .image img',
			},
		};
	}
	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$search_results: this.$element.find(selectors.search_results),
			$images: this.$element.find(selectors.listing_thumb),
		};
	}
	getWidgetId() {
		return this.$element[0].getAttribute('data-id');
	}

	updateSizes( hard = false ) {
		if (window.innerWidth < 1024) return;

		let thumbs = this.elements.$images;
		if ( hard ) {
			thumbs = jQuery('.elementor-element-' + this.getWidgetId() + ' .motors-elementor-inventory-search-results .stm-isotope-listing-item .image img');
		}
		if ( thumbs.length && thumbs[0].hasAttribute('sizes') ) {
			let sizesAttr     = thumbs[0].getAttribute('sizes');
			let actualWidth   = thumbs[0].width;
			let expectedWidth = parseInt(sizesAttr.substring(sizesAttr.lastIndexOf(', ') + 2, sizesAttr.lastIndexOf('px')));
			if ( !isNaN(expectedWidth) && actualWidth > expectedWidth ) {
				let calculatedSizes = sizesAttr.substring(0, sizesAttr.lastIndexOf(', ') + 2) + actualWidth + 'px';
				for ( let i = 0; i < thumbs.length; i++ ) {
					thumbs[i].setAttribute('sizes', calculatedSizes);
				}
			}
		}
	}

	onInit() {
		super.onInit();

		if ( this.elements.$search_results.hasClass('stm-isotope-sorting-grid') && this.elements.$images.length && this.elements.$images[0].hasAttribute('sizes') ) {
			this.updateSizes();

			jQuery(window).on('resize', () => { this.updateSizes() } );
			document.body.addEventListener('stm_results_update', () => { this.updateSizes(true) });
		}
	}
}

jQuery(window).on('elementor/frontend/init', () => {
	const addHandler = ($element) => {
		elementorFrontend.elementsHandler.addHandler(MotorsInventorySearchResults, { $element })
	}
	elementorFrontend.hooks.addAction('frontend/element_ready/motors-inventory-search-results.default', addHandler);
})
